
import os


from qgis.PyQt import QtWidgets, uic
from PyQt5.QtCore import QEvent
from PyQt5.QtWidgets import QWidget, QDialog, QLabel, QApplication, QMainWindow, QToolTip, QStackedWidget
from qgis.PyQt.QtWidgets import QMessageBox


import common


from urbanq.logging.logging_config import logger


from urbanq.menu.license.loopinator import gm, entropy_dance, blip_bloop
from urbanq.menu.license.quxify import fnqk_jlka
from urbanq.menu.license.snorfle import (
    guess_what,
    unknown_purpose,
    something_happens,
    void_nothing,
)


from urbanq.function.security.status import mystery_box, shimmer_blink, sparkle_shine, sparkle_fizzle
from urbanq.function.security.utils import spaghetti_code, flapdoodle_magic


from urbanq.function.execute import execute_code_and_get_result
from urbanq.function.string import validate_input


from urbanq.function.widgetutils import (
    update_progress,
    show_progress,
    qlable_update_visibility,
    qlabel_set_link,
    tabwidget_resize_event,
)


FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'license_dockwidget_base.ui'))


class licenseDockWidget(QDialog, FORM_CLASS):  
    def __init__(self, parent=None):
        
        super(licenseDockWidget, self).__init__(parent)  
        
        
        
        
        
        self.setupUi(self)

        
        self.subscriptionLabelPaid.setProperty("class", "mediumText")
        self.subscriptionLabelFree.setProperty("class", "mediumText")
        self.startDateLabelPaid.setProperty("class", "mediumText")
        self.startDateLabelFree.setProperty("class", "mediumText")
        self.expirationDateLabelPaid .setProperty("class", "mediumText")
        self.expirationDateLabelFree.setProperty("class", "mediumText")
        self.licenseKeyLabel.setProperty("class", "mediumText")
        self.emailLabel.setProperty("class", "mediumText")
        self.btnActivationPaid.setProperty("class", "boldText")
        self.btnActivationFree.setProperty("class", "boldText")
        self.daysRemainingFree.setProperty("class", "mediumText")
        self.daysRemainingPaid.setProperty("class", "mediumText")
        self.tabWidget.tabBar().setProperty("class", "boldText")

        
        self.update_flu()
        self.update_plu()

        
        qlabel_set_link(self.labelWebLink, "http://www.urbanq.kr/vip/")
        qlabel_set_link(self.labelFAQLink, "http://www.urbanq.kr/faq/")

        
        show_progress(self.progressBar, False)

        
        self.tabWidget.resizeEvent = tabwidget_resize_event(self.tabWidget)

        
        [label.installEventFilter(self) for label in [self.imgInfo_1, self.imgInfo_2, self.imgInfo_3, self.imgInfo_4]]

        
        self.tabWidget.setCurrentIndex(1 if blip_bloop() else 0)

        
        self.btnActivationFree.clicked.connect(self.activate_free_trial)

        
        self.btnActivationPaid.clicked.connect(self.activate_sub_trial)

    
    def eventFilter(self, source, event):
        if isinstance(source, QLabel) and event.type() in [QEvent.Enter, QEvent.Leave]:
            QToolTip.showText(event.globalPos(), "시작일시(만료일시)는 한국 시간보다 9시간 늦은 세계 표준 시간(UTC) 기준입니다.", source) \
                if event.type() == QEvent.Enter else QToolTip.hideText()
        return super().eventFilter(source, event)

    
    def validate_and_show_message(self, input_text, input_type, message):
        if not validate_input(input_text, input_type):
            QMessageBox.information(self, "입력 오류", message, QMessageBox.Ok)
            return False
        show_progress(self.progressBar)
        return True

    def update_flu(self):
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        

        code_str = "f1JCQU5RVVJCCAhRGx0WQQ0eGB8ND0AdHBRMCEZYT3hCQU5RVVJCQU5RVVJBQeutmuuivVXrnI7snJbshYHsi4pR7IK07YKu66SeQTs4VeydtuyhjeyWsU7tkK3siql4QkFOUVVSQkFOUVVSEQQCF1sBFgAcBTETFgQoAxAXJwUHBVsBBxU6FA0GSgIBHBgdDE8CGBNcFDpfLFx4QkFOUVVSQkFOUVVSEQQCF1sXGhEHAxQGCw4ANRQGByccFBA3BggaXwYXFjULCQFaAQ4DHBocTA0HF1sEOVMzWH9SQkFOUVVSQkFOUVUBBw0IXxAfAwgCNBEbFk8dFAEmBxkaWRYdDwwBH1seCwdABy5BP0hkUVVSQkFOUVVSQkFOAhAeBE8dBBcBARMHAQEbDQ89BRQGFxIoAxAXTBILBSEXGhVGF1cJAQ4DHBocTA0HF1sEOVUzDOyciVLrrZbroq1O7LOF7Zat7ZmnQEhke1VSQkFOUVVSQkFOUVZS67Om7YudTuu4te2YqeyFg+2Ytk1O7IKw7YKpUuuMk+yLhe2LllHtkKnsiq5C67GuTuyLle2CteycjkLsnYHspq57VVJCQU5RVVJCQU5RBhcOB0ATARwjAhoYAxMWCAEfMwAHBEACEAYnDw8TGRcGSSgQGQEHSGRRVVJCQU5RVVJCQU4CEB4ETwwFGzMBFQcHFAYLDgA3BxcHTx0UASEWGAIUJhoHBBpZVxENDQEDT1JBBwgXExQEWk4TFBEJBhweABwGTA0eGR0QW05SQ0RUV1hHTlBLa05RVVJCQU5RVVJCQR0UGRRMAxofNBEWCBgQARsNDygDEBdMEgsFIRcaFUZ7VVJCQU5RVVJCQU5RVVJCQUzsnInthYXrhYVC7JaR6rOeUe2UseybpkBBBxdVEQ0MAx4bXA4ICF8DKVc8ThgGUiwOABRVFw4SC3tVUkJBTlFVUkJBTlFVUkJBTOutheuiuVLss5btlrlO66a966K5UEIICFEWHQ8MAR9bHgsHQAcuRz9BUlFFUgcNHRR/UkJBTlFVUkJBTlFVUkJBThdX662G66KuQeyzmu2WqVXsprbtl6tB7KW/U1x4aEFOUVVSQkFOUVVSQkJO662F66K5UuucnuycleyFjuyLlVXrg5rsnKJB6rme6rG1Ve2Ev+yLhu2LmU7tkK3siql4QkFOUVVSQkFOUVVSEQQCF1sWAxgdIxAfAwgAGBsVJBMLFFsBBxU6FA0GSmtOUVVSQkFOUVVSQkFOUVVSQENOGBNSAQ4DHBocTA0HF1sEOVQzURwBQi8BHxBSBw0dFH9SQkFOUVVSQkFOUVVSQkFOU+umueuivkBBBxdVEQ0MAx4bXA4ICF8DKVc8Tk1VQkIEAgIQeEJBTlFVUkJBTlFVUkJBTlFX6rm67JyeQeumouuivVdSCwdOEhofDw4AXxkbBE8YKkAvQlxTUUVSBw0dFH9SQkFOUVVSQkFOUVVSQkFOF1cJAQ4DHBocTA0HF1sEOVQzDOyciVLrg4rsnK1MWH94QkFOUVVSQkFNUeutgeuivkLrnJ3snJrshZHsi5FSKwIBH1XsgrPtgr5B7ZCy7Iqtf1JCQU5RVVJCEAIQFx4HPhsBERMWBDEHHAELAwcdHAYbSR0UGRRMBQ8IBiAHDA8YGxsMBigDEBdLaw=="
        exec_globals = {"self": self, "common": common, "qlable_update_visibility": qlable_update_visibility}
        return execute_code_and_get_result(gm(code_str), exec_globals, "result")

    def update_plu(self):
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        

        code_str = "f1JCQU5RVVJCCAhRGx0WQQ0eGB8ND0AdHAJMCEZYT3hCQU5RVVJCQU5RVVJBQeydjuuivVXrnI7snJbshYHsi4rsnI1V7IKz7YK+66SdTiQ8UuydpuyhjuyWvlHtkKnsiq5oQU5RVVJCQU5RVVJCEgsdE1wRFQ8DATYDFQshFBsGJAoYAVwRBBolEAoWSQ0eGB8ND0AdHAJMFzVAKFtoQU5RVVJCQU5RVVJCEgsdE1wHGR4YBxMWCAEfMRMWBD4QHBYnBQcFWwEHFToUDQZKAgEcGB0MTwIYBVwUOlwsXHhCQU5RVVJCQU5RVVIRBAIXWx4LAgsfBhcpBBc0ERsWTx0UASYHGRpZFh0PDAEfWx4LEUAHLkI/SGRRVVJCQU5RVVJCQU4CEB4ETx0EFwEBEwcBARsNDz0FFAYXEj4QHBZMEgsFIRcaFUYXVwkBDgMcGhxMDQcBWwQ5VTMM7JyJUuydguuirU7qtJ3rjrDtmadASGRRVVJCQU5RVVJCQU4CEB4ETwwFGzMBFQcHFAYLDgAhFBsGTx0UASYHGRpZV+uKluukmkHtg4rroK1V7Ziu7IWT7Zi1TFh/eEJBTlFVUkJBTlFVUkFB7J2O66K9VeucjuycluyFgeyLilHrg53snLJC6rmR6rGqUe2EuOyLlu2LmkHtkLLsiq1/UkJBTlFVUkJBTlFVAQcNCF8RExsSPBQYEwsPBx8SIgMICl8GFxY1CwkBWmhBTlFVUkJBTlFVUkJBTlFVUEBBBxdVEQ0MAx4bXA4IHl8DKVc8ThgGUiwOABRVFw4SC3tVUkJBTlFVUkJBTlFVUkJBTOumveuiuVBCCAhRFh0PDAEfWx4LEUAHLkc/QVJRRVIHDR0Uf1JCQU5RVVJCQU5RVVJCQU5T6rm97JyOQuumreuiolNVGwRBDR4YHw0PQB0cAkwXNUQoUl9cTkFVFw4SC3tVUkJBTlFVUkJBTlFVUkJBCFMOEQ0MAx4bXA4IHl8DKVc8E+ycjVXrg5rsnK5DR3t/UkJBTlFVUkJCTuydkeuiuVLrnJ7snJXshY7si5VVOwEOAFHsgrTtgq5C7ZC97Iqye1VSQkFOUVVSEw0PExkXPRQeFRQGBz4YGAYbAAgCGAELShILHRNcBgAXAicXDwAHHxwcBTEPGBFbaA=="
        exec_globals = {"self": self, "common": common, "qlable_update_visibility": qlable_update_visibility}
        return execute_code_and_get_result(gm(code_str), exec_globals, "result")

    
    def exploding_potato(self):
        
        

        code_str = "f1JCQU5RVVJCEh4QEhoHFRoYKhENBQtZXHhCQU5RVVJCQQgdFAIGDgEVGRc9DA8WHBFKEgsdE1wSABwUGwZKSEABFAAHDxpZXFto"
        exec_globals = {"spaghetti_code": spaghetti_code, "flapdoodle_magic": flapdoodle_magic, "self": self}
        return execute_code_and_get_result(gm(code_str), exec_globals, "result")

    
    def activate_free_trial(self):
        try:
            if not self.validate_and_show_message(self.emailEdit.text(), "email", "유효한 이메일 주소를 입력해 주세요."):
                return

            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            

            code_str = "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"
            exec_globals = {"self": self, "common": common, "update_progress": update_progress, "fnqk_jlka": fnqk_jlka, "something_happens": something_happens, "mystery_box": mystery_box, "guess_what": guess_what, "unknown_purpose": unknown_purpose, "void_nothing": void_nothing, "entropy_dance": entropy_dance, "shimmer_blink": shimmer_blink, "sparkle_shine": sparkle_shine, "QMessageBox": QMessageBox}
            return execute_code_and_get_result(gm(code_str), exec_globals, "result")

        except Exception as e:
            logger.error("에러 발생: %s", e, exc_info=True)

            
            

            code_str = "f1JCQU5RVVJCQU5RVSMvBB0CFBUHIwEJWxsMBwEDGBMWCAEfXQEHDQhdVVDslrLrno1MXVVQ7JmG66S5TuuxreyCqO2UquyWjkHtmLLshYDtmKHslqJC7IqF7Y2G7Ze57IuA64q664qGT07qspHqsajshY7thZLroL1O662J7Jyt7ZSGQuyineyKg+yKreyZkVxATU4gOBcREg8WEDANGUA+HltoQU5RVVJCQU5RVVJCEh4QBxkOBDEXHAgYDQtZBhcOB0ABFAAHDxpZXFwSABwUGwZKSEd7"
            exec_globals = {"QMessageBox": QMessageBox, "sparkle_fizzle": sparkle_fizzle, "self": self}
            return execute_code_and_get_result(gm(code_str), exec_globals, "result")

        finally:
            
            show_progress(self.progressBar, False)

    
    def activate_sub_trial(self):
        try:
            
            if not self.validate_and_show_message(self.licenseKeyEdit.text().strip(), "key", "유효한 라이선스 키 형식으로 입력해 주세요."):
                return

            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            

            code_str = "f1JCQU5RVVJCQU5RVVFC7JyZ7YWe64WGVeyWguqzkkHrsaFR7Iqp6rG2QuuzteydqlHtmKDsnIpoQU5RVVJCQU5RVVJCEgsdE1wHGR4dGhYLDwkuBR0WABoeXVtoQU5RVVJCQU5RVVJCFB4VFAYHPh4DGhUQBB0CXQEHDQhfBQANBhwUBgEgABxdVUBSSGR7VVJCQU5RVVJCQU5RVlLrnJ7snJXshY7si5VV7YOWaEFOUVVSQkFOUVVSQg0HEhAcEQQxGhALQlxOAhAeBE8CGBYXDBILOhALJwUHBVsGBxkaWVxcERUcGAVaS2tkUVVSQkFOUVVSQkFOUlXrnI7snJbshYHsi4pR7Zip7IWD7Zi2QeybuuyznH9SQkFOUVVSQkFOUVUBFgAaBAYtAQ4KFFVPQhQAGhsdFQ8xAQAAEg4dFF0eCwILHwYXPQoLCFxSQkJO7J2R66K5UuucnuycleyFjuyLlVXtmK7shZPtmLVkUVVSQkFOUVVSQkFOGBNSERUPBQABPQIBFRBSX1xOVkZCUkZUe1VSQkFOUVVSQkFOUVVSQkEbARETFgQxAQcdBRMLAgZaEQQCF1sCEA4JAxABESMPA1lSV1FHe39SQkFOUVVSQkFOUVVSQkFOUlXrrYbroq5B65yS7JyF7IWV7IuWQuuVte2EouycjVXsoafrspZB7KGu7J+Uf1JCQU5RVVJCQU5RVVJCQU4VEBEQGB4FEBY9BQ8FFFJfQRgeHBY9DwEFHRsMBkYdHBEHDx0UKhkHGEd7VVJCQU5RVVJCQU5RVVJCQQsfAQANERcuERMMAgtZERcBExcBARcGPgoQARNOQQcCKgIDCAouAxcQEgceG082ExsUXHhoQU5RVVJCQU5RVVJCQU5RVVFC65yd7Jya7IWR7IuRUuyCo+2CveukklHrqKHriIZKNQ8TXOyWokLtkL3sirJ7VVJCQU5RVVJCQU5RVVJCQR0ZHB8PBBwuFx4LDwVZXHhoQU5RVVJCQU5RVVJCQU5RVVFC7J2B66KiUeucieychuyFguyLhU7sgrDtgqnrpI5CNCdR7J2x7KGd7JayQe2QsuyKrX9SQkFOUVVSQkFOUVVSQkFOAhAeBE8bARETFgQxARkHSkhke1VSQkFOUVVSQkFOUVVSQkFNUeutgeuivk5B7J2O66K9VeucjuycluyFgeyLilHrprnror5C7Iq9TuuopeuIgVrrjJLsnJXthZ5R67K17ZiqTkHspq7rjrVV7Iqu6rGj7Zi1QlHqsoDqsbbrt6bshbxCUeyKqeqytuyWlkHrt6rshaxcUhYADFHrq53rkKJC67il7Ziy7IWA7ZihWuucnuycleyFjuyLlVUGAwNO7KGt7JiNW2hBTlFVUkJBTlFVUkJBTlFVARIAHBoZFz0SBhgbF0oSCx0TXBIAHBQbBkpIQAEUAAcPGllcW2hBTlFVUkJBTlFVUkJBTlFVBxIFDwUQLRITARYHFxESRgIQHgRPHgMaFRAEHQI3ExBNTkBFQktrZFFVUkJBTlFVUkJBTgIBExYUHS4YFxESDxYQAUJcTgp/UkJBTlFVUkJBTlFVUkJBTlZEQlJGVFFdUCsPGBAZGwZBAhgWFwwSC1EeFxtDQlFX7Jai656OW07rnI3snIHshZLsi4ZB7YOK6rGxVeydku2biu2UueymrlHslL/si4friqrrioVAU1xeaEFOUVVSQkFOUVVSQkFOUVVVUFFeVk9SSkMnHwMTDggKUTQiK0EFFAxQTkFM7Jah656ZSEIgPjhV7JmW66S66rGhTuuxreyCqO2UquyWjkHrnJLsnIXshZXsi5brpJ5B7Ziy7IWA7Zih7ZSSQuyJuU7slrfsi4DrirrrioZPTuqykeqxqOyFju2FkuugvU7rrYnsnK3soo7shZrsm7VAU1xeaEFOUVVSQkFOUVVSQkFOUVVVUVFeVk9SSkMiGBYXDBILUR4XG0EPEgEbFAAaFBFQTkFM7JS966eJSELrnJ3snJrshZHsi5HqsbJC7IWQ6rKb7KGw7J2J66CuQu2YveyFn+2YpeuRreyWuuyLl+uKqeuKil9XW05rTlFVUkJBTlFVUkJBTlFVUkVSW0FSSEJJTDwUCgsMGxxVHBcMDBQHUg0HThAWBgsXDwUcHQwSTgMQEwEJCxVXXkJD7JSi66eNT1LrnJ7snJXshY7si5XqsbVS7JyW666ZTu2YreyFhO2YpuuRuuyWqeqwnuuDqVlS7LS+642hTu2YreyFhO2YpkLtm77sibbrpI1V7LW66rKe7Zep7Iub64q564qRXEBIQntVUkJBTlFVUkJBTlFVUkJBSUVFQkVbTllXPgsCCx8GF0IKCwhVFgcADQUcBAMVCxVXXkJD7JSi66eNT1LrnJ7snJXshY7si5XqsbVS7IWT6rKU7KGv7J2N66CpUuu4pu2YveyFn+2YpeuRreyWuuyLl+uKqeuKil9XW05rTlFVUkJBTlFVUkJBTlFVUkVVW0FSSEJJTD0cEQcPHRRVGQcYThAZAAcACghVGwwADQUcBAdDQlFX7JS+66eeW07rnI3snIHshZLsi4ZB7YOK6rGxVeychuuumkHruKrtmK3shYTtmKZC7IKg7YKy7J+064q964qWTENHXX9SQkFOUVVSQkFOUVVSQkFOVkBCUkZUUV1QNAACGBFSDggNFBsBB0EFFAxQTkFM7JS966eJSELsnYHtm4btlK1V65yO7JyW7IWB7IuKUe2Dkeyft+uKquuKhUBTXF5oQU5RVVJCQU5RVVJCQU5RVVVXVF5WT1JKQysJBRsQBApRGRsBBAACEFIJBBdTWVJA7JSt66eSS1XrnI7snJbshYHsi4pR7YOR6rGyQuumreuiouuRqeyWveyLh+uKquuKhUBTXF5oQU5RVVJCQU5RVVJCQU5RVVVUUV5WT1JKQycfAxMOCApRBRMQAAMUARcQEkxdVVDslrLrno1UUeyfreurieuRvkHrporqsa3rsrXsiarqsaJB7KGq64qd65Gt7Ja67IuX64qp64qKX1dbTmtOUVVSQkFOUVVSQkFOUVVSRVdbQVJIQklMOBsEAw0HFVUWBxcHEhBSKyVMXVVQ7Jay656NVFHsn5DsuKpCKCrqsbFV7J2S7ZuK7ZS57KauUeyUv+yLh+uKquuKhU5RXeyciuynv0Hsm7rss5xcXEBIQntVUkJBTlFVUkJBTlFVUkJBSUZFQkVbTllXNgcXBxIQUislTgMQAxcIHBQRUgQOHFERFwMCGhgDExYIAR9XXkJD7Ja+656dT1Lsn4fsuLlOODHqsbJC7ZSl7Ju67ZSY64q964qWQknruKrtmK3shYTtmKZC7Ju17LODWFtQS01kUVVSQkFOUVVSQkFOUVVSQkZZREVVWEFGUzEXFAgNFFU7JkEcFAQHCxMLFVUUDRNOAxATARUHBxQGCw4AU1lSQOyWseuegktV7J+X7Li6QSc16rG1Uu2Upuybte2Uh+uKueuKkVJK7J+N7Ziy7IWA7ZihUuybtuyzjEdfV1tOa05RVVJCQU5RVVJCQU5RVVJFUV5BUkhCSUwwG1IHExweB1IKAB1RGhEBFBwDEBZMQT4dEBMRBE4DEAYQGExdVVDslrLrno1UUeyUuVLsibpB7Jao64ulVeyZluukuuqxoU7rsa3sgqjtl7rsi5friqnriopfVeuKluyKvkHsirLrjrXtlIFS7KKe7IWZ7Ju6X1dbaEFOUVVSQkFOUVVSQhxke1VSQkFOUVVSQkFOUVZS65ye7JyV7IWO7IuVVe2YruyFk+2YtU7sgrDtgqlS7JSu66edZFFVUkJBTlFVUkJBTgUcBg4EQlEYFxESDxYQUl9BHQUUBhcSMRwQAREACRQGXAUEGlkGBgMVGwIqEQ0FC11VARYAGgQGLQ8EHQIUFQcSNVZFQlJGM1h/UkJBTlFVUkJBTlFVIy8EHQIUFQcjAQlbGwwHAQMYExYIAR9dAQcNCF1VBgsVAhRZUg8EHQIUFQdNTiA4FxESDxYQMA0ZQD4eW2g="
            exec_globals = {"self": self, "QMessageBox": QMessageBox, "update_progress": update_progress, "unknown_purpose": unknown_purpose, "void_nothing": void_nothing, "entropy_dance": entropy_dance, "shimmer_blink": shimmer_blink, "sparkle_shine": sparkle_shine}
            return execute_code_and_get_result(gm(code_str), exec_globals, "result")

        except Exception as e:
            logger.error("에러 발생: %s", e, exc_info=True)

            
            

            code_str = "f1JCQU5RVVJCQU5RVSMvBB0CFBUHIwEJWxsMBwEDGBMWCAEfXQEHDQhdVVDslrLrno1MXVVQ7JmG66S5TuuxreyCqO2UquyWjkHtmLLshYDtmKHslqJC7IqF7Y2G7Ze57IuA64q664qGT07qspHqsajshY7thZLroL1O662J7Jyt7ZSGQuyineyKg+yKreyZkVxATU4gOBcREg8WEDANGUA+HltoQU5RVVJCQU5RVVJCEh4QBxkOBDEXHAgYDQtZBhcOB0ABFAAHDxpZXFwSABwUGwZKSEd7"
            exec_globals = {"self": self, "QMessageBox": QMessageBox, "sparkle_fizzle": sparkle_fizzle}
            return execute_code_and_get_result(gm(code_str), exec_globals, "result")

        finally:
            
            show_progress(self.progressBar, False)














